#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Orbitals of the Hydrogen AtomMod01.fsh   by   tpfto
//https://www.shadertoy.com/view/tlX3WN
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// The MIT License
// Copyright © 2019 J. M.
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// Plotting the density functions (orbitals, Schrödinger equation solutions) for the hydrogen atom, cf. https://en.wikipedia.org/wiki/Atomic_orbital

// some constants
#define PI 3.14159265359

// dark and light colors from Solarized (https://ethanschoonover.com/solarized/)
#define DARK vec3(0., 0.169, 0.212)
#define LIGHT vec3(0.992, 0.965, 0.89)
#define GRAY vec3(0.576, 0.631, 0.631)

// XY range of the display.
#define DISP_SCALE 130.0 

// Clip areas outside DISP_SCALE
#define CLIP_SQUARE

// maximum supported polynomial order
#define MAX_POLYNOMIAL_ORDER 9

// Kronecker delta
#define kd(n, k) ((n == k) ? 1.0 : 0.0)

// Clenshaw's algorithm for the Laguerre polynomial
float laguerre(int n, int aa, float x)
{
	float a = float(aa);
    float u = 0.0, v = 0.0, w = 0.0;
    
    for (int k = MAX_POLYNOMIAL_ORDER; k > 0; k--)
    {
        float kk = float(k);
        w = v; v = u;
        u = kd(n, k) + (2.0 * kk + a + 1.0 - x)/(kk + 1.0) * v - (kk + a + 1.0) * w/(kk + 2.0);
    }
    
    return kd(n, 0) + (a - x + 1.0) * u - 0.5 * (a + 1.0) * v;
}

// Clenshaw's algorithm for the normalized associated Legendre polynomial (spherical harmonics)
float alegp(int n, int m, float x)
{
    int am = abs(m);
    float u = 0.0, v = 0.0, w = 0.0;
    
    for (int k = MAX_POLYNOMIAL_ORDER; k >= 0; k--)
    {
        float kp = float(k + 1);
        float mk1 = float(2 * am) + kp, mk2 = float(2 * (am + k) + 1);
        w = v; v = u;
        u = kd(n, am + k) + sqrt((mk2 * (mk2 + 2.0))/(kp * mk1)) * x * v - sqrt((kp * mk1 * (mk2 + 4.0))/((kp + 1.0) * (mk1 + 1.0) * mk2)) * w;
    }

    for (int k = 1; k <= am; k++)
    {
        u *= sqrt((1.0 - 0.5/float(k)) * (1.0 - x) * (1.0 + x));
    }
    
    return (((m > 0) && ((am & 1) == 1)) ? -1.0 : 1.0) * u * sqrt((0.5 * float(am) + 0.25)/PI);
}

// custom colormap

vec3 gvb( float t )
{
	 return vec3(min(0.16 + 0.845 * t, 0.47 + 0.072 * t), min(0.14 + 2.15 * t, 1.55 - 1.386 * t), max(0.13 - 0.325 * t, 1.47 * t - 0.591));
}

 // density function

float hdensity(int n, int l, int m, vec2 p)
{
      float r = length(p);

      float rho = 2.0 * r/float(n);
      float tmp = laguerre(n - l - 1, 2 * l + 1, rho) * alegp(l, m, p.y/r);

      return exp(2.0 * float(l + 1) * log(0.5 * rho) - rho) * tmp * tmp;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
        vec2 aspect = iResolution.xy / iResolution.y;
        vec2 uv = ( fragCoord.xy / iResolution.y ) - 0.5 * aspect;
        uv *= DISP_SCALE;

        // principal quantum number (cf. https://en.wikipedia.org/wiki/Quantum_number)
        int n = 5;
            
        // use a modified Szudzik pairing function (http://szudzik.com/ElegantPairing.pdf)
        // to generate the corresponding valid azimuthal and magnetic quantum numbers
        float k = mod(floor(0.2 * iTime), float(n * n));
        int q = int(floor(sqrt(k)));
        int l = q, m = int(k) - q * (1 + q);
            
        // rescale density function with hyperbolic tangent
        vec3 col = gvb(tanh(1.5 * hdensity(n, l, m, uv)));

        #ifdef CLIP_SQUARE
        col = mix(DARK, col, 1.0 - step(0.5 * DISP_SCALE, abs(uv.x)));
        #endif

        fragColor = vec4( col, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

